varying vec2 		texcoord;

uniform sampler2D 	bmp,
		sampler2D	dif;
varying vec3		w0,
					w1,
					w2;
varying vec3		viewDir;
uniform float		specPower,
					specScale;
uniform vec3		lightDir;
uniform float		lightscale;
uniform vec3		lightcolor;

void main()
{
	vec4 color=texture2D(dif,texcoord.st);
	
	vec4 normalColor=texture2D(bmp,texcoord.st);
	vec3 normal=(normalColor.xyz*2.0)-1.0;
	normalize(normal);
	
	vec3 N;
	N.x=dot(w0,normal);
	N.y=dot(w1,normal);
	N.z=dot(w2,normal);

	float diffuse = max(dot(lightDir,N.xyz),0.0);
	
	vec3 vdir=normalize(viewDir);
	vec3 halfv = lightDir+vdir;
	halfv=normalize(halfv);
	float spec = clamp(dot(halfv, N.xyz),0.0,1.0);
	spec = pow(spec,specPower)*specScale;

	gl_FragColor.rgb= ((color*diffuse) + spec)*lightColor*lightScale;
	gl_FragColor.a=color.a;
}
